//############################################################
//
// SpeedDome.cpp : Defines the class behaviors for the application.
//
//############################################################

#include "stdafx.h"
#include "SpeedDome.h"
#include "MainFrm.h"
#include "ChildFrm.h"
#include "SpeedDomeDoc.h"
#include "SpeedDomeView.h"
#include "about.h"
#include "CapSetup.h"
#include "VideoCapture.h"
#include "vfw.h"
#include "InitialDlg.h"
#include "PresetDlg.h"
#include "SequenceDlg.h"
#include "CruiseDlg.h"
#include "VideoMainCWnd.h"
#include "comm.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define _MAIN
	#include "GlobalVar.h"
#undef  _MAIN


/////////////////////////////////////////////////////////////////////////////
// CSpeedDomeApp

BEGIN_MESSAGE_MAP(CSpeedDomeApp, CWinApp)
	//{{AFX_MSG_MAP(CSpeedDomeApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)

	//-------- ComPort ----------------------------------------
	ON_COMMAND(ID_MITEM_COM1,S_SetCom1)
	ON_COMMAND(ID_MITEM_COM2,S_SetCom2)
	ON_COMMAND(ID_MITEM_COM3,S_SetCom3)
	ON_COMMAND(ID_MITEM_COM4,S_SetCom4)
	//-------- Dome -------------------------------------------
	ON_COMMAND(ID_MITEM_DOME_RENAME,	S_DomeRenameDlg)
	//-------- Preset -----------------------------------------
	ON_COMMAND(ID_MITEM_PT_READ_EE,		S_PresetDlgEE)
	ON_COMMAND(ID_MITEM_PT_READ_FILE,	S_PresetDlgFiles)
	ON_COMMAND(ID_MITEM_PT_SAVE_EE,		S_PresetSaveEE)
	ON_COMMAND(ID_MITEM_PT_SAVE_ALL,	S_PresetSaveAll)
	ON_COMMAND(ID_MITEM_PT_CLEAR_EE,	S_PresetClearEE)
	ON_COMMAND(ID_MITEM_PT_CLEAR_ALL,	S_PresetClearAll)
	ON_COMMAND(ID_MITEM_PT_RENAME,		S_PresetRenameDlg)
	//-------- Sequence ---------------------------------------
	ON_COMMAND(ID_MITEM_SQ_READ_EE,		S_SequenceDlgEE)
	ON_COMMAND(ID_MITEM_SQ_READ_FILES,	S_SequenceDlgFiles)
	//-------- Cruise -----------------------------------------
	ON_COMMAND(ID_MITEM_CRUISE_SAVE_FILE,	S_CruiseDlg)
	ON_COMMAND(ID_MITEM_READ_FILE_TO_EE,	S_WriteCruiseFileToEE)
	//-------- Joystick ---------------------------------------
	/*
	ON_MESSAGE(MM_JOY1BUTTONDOWN,S_JoyButtonDown)
	ON_MESSAGE(MM_JOY1BUTTONUP,S_JoyButtonUp)
	ON_MESSAGE(MM_JOY1MOVE,S_JoyMove)
	*/

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSpeedDomeApp construction

CSpeedDomeApp::CSpeedDomeApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

/////////////////////////////////////////////////////////////////////////////
// The one and only CSpeedDomeApp object

CSpeedDomeApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CSpeedDomeApp initialization

BOOL CSpeedDomeApp::InitInstance()
{
	AfxEnableControlContainer();

	//--------- Initial Progress -----------------------------
	CInitialDlg		InitialDlg;
	
	int nResponse = InitialDlg.DoModal();
	if (nResponse == IDOK)
		{	}
	else if (nResponse == IDCANCEL)
		{	}
	//--------------------------------------------------------
	
	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	// Change the registry key under which our settings are stored.
	// You should modify this string to be something appropriate
	// such as the name of your company or organization.
	SetRegistryKey(_T("Local AppWizard-Generated Applications"));

	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_SPEEDDTYPE,
		RUNTIME_CLASS(CSpeedDomeDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CSpeedDomeView));
	//AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);

	// Dispatch commands specified on the command line
	if (!ProcessShellCommand(cmdInfo))
		return FALSE;

	// The main window has been initialized, so show and update it.
	pMainFrame->ShowWindow(SW_SHOWMAXIMIZED);
	pMainFrame->UpdateWindow();

	//---- Add Doc/View but don't show template ------------
	AddDocTemplate(pDocTemplate);
	//---- Generate control dialog -------------------------
	m_ControlDlg=new CControlDlg;
	G_ControlDlg=m_ControlDlg;			//-- Save Dialog
	m_ControlDlg->Create(IDD_SPEEDDOME,NULL);
	//---- Create Video main window ------------------------
	G_VideoMainCWnd=new CVideoMainCWnd;

	G_VideoMenu=::LoadMenu(AfxGetInstanceHandle(),MAKEINTRESOURCE(IDR_MENU_VIDEO)  );
	LPCTSTR y_ClassName=AfxRegisterWndClass( CS_HREDRAW,0,0,0 ); 

	RECT rect;
		rect.left=0;					
		rect.top=70;
		rect.right=(long)(640*0.8)+rect.left;	
		rect.bottom=(long)(480*0.8)+rect.top;

	G_VideoMainCWnd->CreateEx(WS_EX_LEFT,y_ClassName ,
		"ViewPort",WS_OVERLAPPED,
		rect.left,rect.top,rect.right,rect.bottom,
		AfxGetMainWnd()->m_hWnd,G_VideoMenu,NULL);

	//---- Enumerate Driver  -------------------------------
	VideoCapEnumerateDrivers(G_VideoMainCWnd->m_hWnd);
	//------------------------------------------------------

	return TRUE;
}
//################################################################
void CSpeedDomeApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

